/*
 * Decompiled with CFR 0.152.
 */
package com.android.payment.data;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.QueryParamTypes;
import com.android.payment.domain.model.SettlementDto;
import com.android.payment.domain.use_case.InsertOrReplaceSettlement;
import com.android.payment.domain.use_case.MakeSettlementQuery;
import com.android.payment.domain.use_case.QuerySettlements;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncException;
import java.util.List;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class SettlementRepo
extends AndroidRepository<SettlementDto> {
    @Resource
    @Lazy
    private InsertOrReplaceSettlement insertOrReplaceSettlement;
    @Resource
    @Lazy
    private QuerySettlements querySettlements;
    @Resource
    @Lazy
    private MakeSettlementQuery makeSettlementQuery;

    public SettlementRepo(DbConnection dbConnection) {
        super(dbConnection);
    }

    protected BaseResponse<GenericResponse> insert(SettlementDto item, LoginDto login, TransactionStatus status) throws TncException {
        return this.makeBaseGenericResponse(status, () -> this.insertOrReplaceSettlement.invoke(item));
    }

    public BaseResponse<SettlementDto> customQueryAsObject(RequestData request, Paging paging, LoginDto login) {
        String sql = this.makeSql(request, paging, login);
        if (sql == null) {
            return null;
        }
        List result = this.querySettlements.invoke(sql, login);
        return new BaseResponse.Builder().data(result).totalCount(this.getTotalCount()).totalPages(this.getTotalPages()).build();
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(RequestData request, SettingLoader settingsLoader) {
        return this.makeSettlementQuery.invoke(settingsLoader);
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.SETTLEMENT;
    }
}

